--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNsightTool ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCdispRenderEffect
  local LOCcalcRenderEffect
  local LOCsurface
  local LOCshapes = #()
  local LOCoptions = #(DYNuiResourcesSightTool[1], \       -- 01
                      DYNuiResourcesSightTool[2],  \       -- 02
                      DYNuiResourcesSightTool[3],  \       -- 03
                      DYNuiResourcesSightTool[4],  \       -- 04
                      DYNuiResourcesSightTool[5],  \       -- 05
                      DYNuiResourcesSightTool[6],  \       -- 06
                      DYNuiResourcesSightTool[7],  \       -- 07
                      DYNuiResourcesSightTool[8],  \       -- 08
                      DYNuiResourcesSightTool[9],  \       -- 09
                      DYNuiResourcesSightTool[10], \       -- 10
                      DYNuiResourcesSightTool[11], \       -- 11
                      DYNuiResourcesSightTool[12], \       -- 12
                      DYNuiResourcesSightTool[13], \       -- 13
                      DYNuiResourcesSightTool[14], \       -- 14
                      DYNuiResourcesSightTool[15], \       -- 15
                      DYNuiResourcesSightTool[16], \       -- 16
                      DYNuiResourcesSightTool[17], \       -- 17
                      DYNuiResourcesSightTool[18], \       -- 18
                      DYNuiResourcesSightTool[19], \       -- 19
                      DYNuiResourcesSightTool[20])         -- 20

  local LOCtxtOptions = #(DYNuiResourcesLabels[121], \     -- 01
                      DYNuiResourcesLabels[401], \         -- 02
                      DYNuiResourcesLabels[401], \         -- 03
                      DYNuiResourcesLabels[401], \         -- 04
                      DYNuiResourcesLabels[401], \         -- 05
                      DYNuiResourcesLabels[401], \         -- 06
                      DYNuiResourcesLabels[401], \         -- 07
                      DYNuiResourcesLabels[401], \         -- 08
                      DYNuiResourcesLabels[401], \         -- 09
                      DYNuiResourcesLabels[401], \         -- 10
                      DYNuiResourcesLabels[401], \         -- 11
                      DYNuiResourcesLabels[401], \         -- 12
                      DYNuiResourcesLabels[401], \         -- 13
                      DYNuiResourcesLabels[401], \         -- 14
                      DYNuiResourcesLabels[401], \         -- 15
                      DYNuiResourcesLabels[401], \         -- 16
                      DYNuiResourcesLabels[401], \         -- 17
                      DYNuiResourcesLabels[401], \         -- 18
                      DYNuiResourcesLabels[401], \         -- 19
                      DYNuiResourcesLabels[402])           -- 20


  fn DYNFUNgetObjectsWithSpecifiedObjectID FUNdnLv FUNobjID =
  (
    FUNdnLv.Items.clear()

    --- Get Geom Nodes Matching Current ObjID
    local LOCarray = #()
    for i in geometry do
    (
      if i.gBufferChannel == FUNobjID then append LOCarray i
    )

    --- Add Selected Nodes to ListView
    for i in LOCarray do
    (
      local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" i.name
      LOClistItem.tag = i.inode.handle as string
      FUNdnLv.Items.Add LOClistItem
    )
    if LOCarray.count > 0 then select LOCarray else clearSelection()
  )

  fn DYNFUNsetDispRenderEffectParams FUNre =
  (
    FUNre.framePad      = DYNsightTool.SPDYNframePad.value       -- : integer
    FUNre.fontScale     = DYNsightTool.SPDYNfontScale.value      -- : integer
    FUNre.dimBG         = DYNsightTool.CKDYNdimBGCheck.checked   -- : boolean
    FUNre.alphaBlend    = DYNsightTool.CKDYNblendCheck.checked   -- : boolean
    FUNre.reqdDistance  = DYNsightTool.SPDYNreqdDistance.value   -- : integer
    FUNre.TypeTextTL    = DYNsightTool.DDDYNtypeTextTL.selection -- : integer
    FUNre.TypeTextTC    = DYNsightTool.DDDYNtypeTextTC.selection -- : integer
    FUNre.TypeTextTR    = DYNsightTool.DDDYNtypeTextTR.selection -- : integer
    FUNre.TypeTextBL    = DYNsightTool.DDDYNtypeTextBL.selection -- : integer
    FUNre.TypeTextBC    = DYNsightTool.DDDYNtypeTextBC.selection -- : integer
    FUNre.TypeTextBR    = DYNsightTool.DDDYNtypeTextBR.selection -- : integer
    FUNre.EditTextTL    = DYNsightTool.EDDYNeditTextTL.text      -- : string
    FUNre.EditTextTC    = DYNsightTool.EDDYNeditTextTC.text      -- : string
    FUNre.EditTextTR    = DYNsightTool.EDDYNeditTextTR.text      -- : string
    FUNre.EditTextBL    = DYNsightTool.EDDYNeditTextBL.text      -- : string
    FUNre.EditTextBC    = DYNsightTool.EDDYNeditTextBC.text      -- : string
    FUNre.EditTextBR    = DYNsightTool.EDDYNeditTextBR.text      -- : string
    FUNre.useImage      = if (doesFileExist DYNsightTool.EDDYNimageName.text) then DYNsightTool.CKDYNuseImageCheck.checked else false -- : boolean
    FUNre.imageFName    = DYNsightTool.EDDYNimageName.text       -- : string
    FUNre.image_x       = DYNsightTool.SPDYNimageposx.value      -- : integer
    FUNre.image_y       = DYNsightTool.SPDYNimageposy.value      -- : integer
    FUNre.imgOpacity    = DYNsightTool.SPDYNopacity.value        -- : integer
    FUNre.transfer_mode = DYNsightTool.DDDYNtransfer.selection   -- : integer
    DYNsightTool.LBDYNeditTextTL.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextTL]
    DYNsightTool.LBDYNeditTextTC.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextTC]
    DYNsightTool.LBDYNeditTextTR.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextTR]
    DYNsightTool.LBDYNeditTextBL.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextBL]
    DYNsightTool.LBDYNeditTextBC.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextBC]
    DYNsightTool.LBDYNeditTextBR.text = DYNsightTool.LOCtxtOptions[FUNre.TypeTextBR]
  )

  fn DYNFUNsetCalcRenderEffectParams FUNre =
  (
    FUNre.blendPercentage = DYNsightTool.SPDYNblend.value            -- (Percentage) : float
    FUNre.nodeID          = DYNsightTool.SPDYNnodeID.value           -- (Object_ID) : integer
    FUNre.markerColor     = DYNsightTool.CPDYNmarker.color           -- (Marker_Color) : RGB color
    FUNre.showProgress    = DYNsightTool.CKDYNshowProgress.checked   -- (Show_Progress) : boolean
    FUNre.drawMarker      = DYNsightTool.CKDYNdrawMarker.checked     -- (Draw_Maker) : boolean
    FUNre.drawCrosshairs  = DYNsightTool.CKDYNdrawHairs.checked      -- (Draw_Crosshairs) : boolean
    FUNre.areaBlend       = DYNsightTool.CKDYNblend.checked          -- (Pixel_Blend_Target_Area) : boolean
    if DYNsightTool.CKDYNoutputName.checked then
    (
      FUNre.output        = DYNsightTool.EDDYNoutputName.text        -- (Statistics_Output_File) : string
    )
    else
    (
      FUNre.output        = ""
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNgroupC1  pos:[11,10]  width:350 height:218
  checkbox CKDYNuseCalc  pos:[25,30]  width:150 align:#left

  label LBDYNnodeID      pos:[182,30] width:90
  spinner SPDYNnodeID "" pos:[275,30] type:#integer range:[1,65535,100] fieldwidth:60 enabled:false

  pickbutton PKDYNobject  width:80 enabled:false pos:[182,50]
  button BUDYNobjectR     width:80 enabled:false pos:[267,50]
  dotNetControl  dnLv "System.Windows.Forms.ListView" pos:[182,75]  width:165 height:60

  checkbox CKDYNshowProgress pos:[25,65]  width:150 align:#left
  checkbox CKDYNdrawHairs    pos:[25,90]  width:150 align:#left
  checkbox CKDYNdrawMarker   pos:[25,115] width:150 align:#left

  checkbox CKDYNblend        pos:[25,150] width:150 align:#left
  label LBDYNblend           pos:[182,151] width:90
  spinner SPDYNblend  ""     pos:[275,151] type:#integer range:[0,100,100] fieldwidth:40 enabled:false
  colorpicker CPDYNmarker    pos:[327,151] width:20 height:16

  checkbox CKDYNoutputName  width:260 pos:[25,177]  enabled:false height:19
  edittext EDDYNoutputName  width:260 pos:[20,197]  enabled:false
  button BUDYNoutputNameBtn width:60  pos:[287,195] enabled:false

  groupBox GBDYNgroupD1 pos:[11,236] width:350 height:480
  checkbox CKDYNuseText pos:[25,256] align:#left width:100

  label LBDYNtypeTextTL pos:[25,297] width:150 enabled:false
  label LBDYNtypeTextTC pos:[25,343] width:150 enabled:false
  label LBDYNtypeTextTR pos:[25,389] width:150 enabled:false
  label LBDYNtypeTextBL pos:[25,435] width:150 enabled:false
  label LBDYNtypeTextBC pos:[25,481] width:150 enabled:false
  label LBDYNtypeTextBR pos:[25,527] width:150 enabled:false
  dropdownlist DDDYNtypeTextTL "" pos:[25,313] items:LOCoptions width:150 selection:8  enabled:false
  dropdownlist DDDYNtypeTextTC "" pos:[25,359] items:LOCoptions width:150 selection:17 enabled:false
  dropdownlist DDDYNtypeTextTR "" pos:[25,405] items:LOCoptions width:150 selection:12 enabled:false
  dropdownlist DDDYNtypeTextBL "" pos:[25,451] items:LOCoptions width:150 selection:5  enabled:false
  dropdownlist DDDYNtypeTextBC "" pos:[25,497] items:LOCoptions width:150 selection:2  enabled:false
  dropdownlist DDDYNtypeTextBR "" pos:[25,543] items:LOCoptions width:150 selection:9  enabled:false
  label LBDYNeditTextTL    pos:[182,297] width:165 enabled:false
  label LBDYNeditTextTC    pos:[182,343] width:165 enabled:false
  label LBDYNeditTextTR    pos:[182,389] width:165 enabled:false
  label LBDYNeditTextBL    pos:[182,435] width:165 enabled:false
  label LBDYNeditTextBC    pos:[182,481] width:165 enabled:false
  label LBDYNeditTextBR    pos:[182,527] width:165 enabled:false
  edittext EDDYNeditTextTL "" pos:[178,313] width:169 enabled:false
  edittext EDDYNeditTextTC "" pos:[178,359] width:169 enabled:false
  edittext EDDYNeditTextTR "" pos:[178,405] width:169 enabled:false
  edittext EDDYNeditTextBL "" pos:[178,451] width:169 enabled:false
  edittext EDDYNeditTextBC "" pos:[178,497] width:169 enabled:false
  edittext EDDYNeditTextBR "" pos:[178,543] width:169 enabled:false

  checkbox CKDYNdimBGCheck pos:[178,257] enabled:false align:#left width:150
  checkbox CKDYNblendCheck pos:[178,274] enabled:false align:#left width:150

  label LBDYNfontScale    width:90 enabled:false pos:[25,573]
  label LBDYNframePad     width:110 enabled:false pos:[182,573]
  label LBDYNreqdDistance width:110 enabled:false pos:[182,593]
  spinner SPDYNfontScale    "" range:[1,10,1]        type:#integer fieldWidth:40 enabled:false pos:[122,573]
  spinner  SPDYNframePad    "" range:[1,15,4]        type:#integer fieldWidth:40 enabled:false pos:[295,573]
  spinner SPDYNreqdDistance "" range:[1,9999999,300] type:#integer fieldWidth:40 enabled:false pos:[295,593]

  checkbox CKDYNuseImageCheck pos:[27,614] align:#left width:150
  edittext EDDYNimageName                 pos:[22,635]  width:260 enabled:false
  button BUDYNimageNameBtn                pos:[288,633] width:60 enabled:false

  label LBDYNimageposx pos:[25,658] width:90 enabled:false
  label LBDYNimageposy pos:[25,680] width:90 enabled:false
  spinner SPDYNimageposx "" pos:[122,658]  type:#integer range:[-4000,4000,15] fieldwidth:40 enabled:false
  spinner SPDYNimageposy "" pos:[122,680]  type:#integer range:[-4000,4000,25] fieldwidth:40 enabled:false

  label LBDYNopacity pos:[182,659] width:110 enabled:false
  spinner SPDYNopacity "" pos:[295,659] type:#integer range:[0,100,100]     fieldwidth:40 enabled:false

  dropdownlist DDDYNtransfer              pos:[182,680] width:165 enabled:false

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsightTool open do
  (
    DYNsightTool.title      = DYNuiRolloutNames[49]

    GBDYNgroupD1.text       = DYNuiResourcesGroups[114]
    GBDYNgroupC1.text       = DYNuiResourcesGroups[115]

    BUDYNimageNameBtn.text  = DYNuiResourcesButtons[99]
    BUDYNoutputNameBtn.text = DYNuiResourcesButtons[99]
    PKDYNobject.text        = DYNuiResourcesButtons[97]
    BUDYNobjectR.text       = DYNuiResourcesButtons[98]

    DDDYNtransfer.items     = #(DYNuiResourcesSightTool[29], DYNuiResourcesSightTool[30], DYNuiResourcesSightTool[31], DYNuiResourcesSightTool[32], DYNuiResourcesSightTool[33], DYNuiResourcesSightTool[34], DYNuiResourcesSightTool[35], DYNuiResourcesSightTool[36], DYNuiResourcesSightTool[37])

    LBDYNnodeID.text        = DYNuiResourcesSightTool[38]
    LBDYNblend.text         = DYNuiResourcesSightTool[39]
    LBDYNfontScale.text     = DYNuiResourcesSightTool[40]
    LBDYNframePad.text      = DYNuiResourcesSightTool[41]
    LBDYNreqdDistance.text  = DYNuiResourcesSightTool[42]
    LBDYNimageposx.text     = DYNuiResourcesSightTool[43]
    LBDYNimageposy.text     = DYNuiResourcesSightTool[44]
    LBDYNopacity.text       = DYNuiResourcesSightTool[45]
    LBDYNtypeTextTL.text    = DYNuiResourcesSightTool[46]
    LBDYNtypeTextTC.text    = DYNuiResourcesSightTool[47]
    LBDYNtypeTextTR.text    = DYNuiResourcesSightTool[48]
    LBDYNtypeTextBL.text    = DYNuiResourcesSightTool[49]
    LBDYNtypeTextBC.text    = DYNuiResourcesSightTool[50]
    LBDYNtypeTextBR.text    = DYNuiResourcesSightTool[51]
    CKDYNuseText.text       = DYNuiResourcesButtons[30]
    CKDYNuseCalc.text       = DYNuiResourcesButtons[30]
    CKDYNshowProgress.text  = DYNuiResourcesSightTool[21]
    CKDYNdrawHairs.text     = DYNuiResourcesSightTool[22]
    CKDYNdrawMarker.text    = DYNuiResourcesSightTool[23]
    CKDYNblend.text         = DYNuiResourcesSightTool[24]
    CKDYNuseImageCheck.text = DYNuiResourcesSightTool[25]
    CKDYNdimBGCheck.text    = DYNuiResourcesSightTool[26]
    CKDYNblendCheck.text    = DYNuiResourcesSightTool[27]
    CKDYNoutputName.text    = DYNuiResourcesSightTool[28]

    --- Add Or Get Scripted Display RenderEffect
    if numEffects > 0 then
    (
      for i = 1 to numEffects do
      (
        if classof (getEffect i) == Civil_View_Sight_Checker__Calc then LOCcalcRenderEffect = (getEffect i)
        if classof (getEffect i) == dSightRender         then LOCdispRenderEffect = (getEffect i)
      )
    )

    if LOCcalcRenderEffect == undefined then
    (
      addEffect (Civil_View_Sight_Checker__Calc())
      for i = 1 to numEffects do (if classof (getEffect i) == Civil_View_Sight_Checker__Calc then LOCcalcRenderEffect = (getEffect i))
    )

    if LOCdispRenderEffect == undefined then
    (
      addEffect (dSightRender())
      for i = 1 to numEffects do (if classof (getEffect i) == dSightRender         then LOCdispRenderEffect = (getEffect i))
    )

    --- Set Up Render Effect Defaults
    if LOCcalcRenderEffect.nodeID == 0         then LOCcalcRenderEffect.nodeID = 100
    if LOCcalcRenderEffect.output == undefined then LOCcalcRenderEffect.output = ""

    --- Grab Current Settings From Calculation Render Effect
    DYNsightTool.CKDYNuseCalc.checked       = IsActive LOCcalcRenderEffect
    DYNsightTool.SPDYNblend.value           = LOCcalcRenderEffect.blendPercentage  -- (Percentage) : float
    DYNsightTool.SPDYNnodeID.value          = LOCcalcRenderEffect.nodeID           -- (Object_ID) : integer
    DYNsightTool.CPDYNmarker.color          = LOCcalcRenderEffect.markerColor      -- (Marker_Color) : RGB color
    DYNsightTool.CKDYNshowProgress.checked  = LOCcalcRenderEffect.showProgress     -- (Show_Progress) : boolean
    DYNsightTool.CKDYNdrawMarker.checked    = LOCcalcRenderEffect.drawMarker       -- (Draw_Maker) : boolean
    DYNsightTool.CKDYNdrawHairs.checked     = LOCcalcRenderEffect.drawCrosshairs   -- (Draw_Crosshairs) : boolean
    DYNsightTool.CKDYNblend.checked         = LOCcalcRenderEffect.areaBlend        -- (Pixel_Blend_Target_Area) : boolean
    DYNsightTool.EDDYNoutputName.text       = if LOCcalcRenderEffect.output == "" then ((getDir #renderOutput) + "\\SightChecker.txt") else LOCcalcRenderEffect.output
    DYNsightTool.CKDYNoutputName.checked    = if LOCcalcRenderEffect.output == "" then false else true

    DYNsightTool.CKDYNuseCalc.enabled       = IsActive LOCcalcRenderEffect
    DYNsightTool.LBDYNblend.enabled         = IsActive LOCcalcRenderEffect
    DYNsightTool.SPDYNblend.enabled         = IsActive LOCcalcRenderEffect
    DYNsightTool.LBDYNnodeID.enabled        = IsActive LOCcalcRenderEffect
    DYNsightTool.SPDYNnodeID.enabled        = IsActive LOCcalcRenderEffect
    DYNsightTool.PKDYNobject.enabled        = IsActive LOCcalcRenderEffect
    DYNsightTool.BUDYNobjectR.enabled       = IsActive LOCcalcRenderEffect
    DYNsightTool.CPDYNmarker.enabled        = IsActive LOCcalcRenderEffect
    DYNsightTool.CKDYNshowProgress.enabled  = IsActive LOCcalcRenderEffect
    DYNsightTool.CKDYNdrawMarker.enabled    = IsActive LOCcalcRenderEffect
    DYNsightTool.CKDYNdrawHairs.enabled     = IsActive LOCcalcRenderEffect
    DYNsightTool.CKDYNblend.enabled         = IsActive LOCcalcRenderEffect
    DYNsightTool.CKDYNoutputName.enabled    = IsActive LOCcalcRenderEffect
    DYNsightTool.BUDYNoutputNameBtn.enabled = IsActive LOCcalcRenderEffect

    DYNFUNdnListViewStyle dnLv false false
    dnLv.multiSelect        = false
    dnLv.AllowColumnReorder = false
    dnLv.sorting            = DYNdnSortOrderClass.ascending
    dnLv.Columns.add DYNuiResourcesLvColumns[92] 140

    /*
      .resultTime () : integer
      .resultMin () : float
      .resultMax () : float
      .resultAvg () : float
      .resultPct () : float
    */

    --- Grab Current Settings From Display Render Effect
    if LOCdispRenderEffect.imageFName == "" or not (doesFileExist LOCdispRenderEffect.imageFName) then LOCdispRenderEffect.imageFName = DYNiconsPath + "3dsMax.png"

    DYNsightTool.CKDYNuseText.checked       = IsActive LOCdispRenderEffect
    DYNsightTool.SPDYNframePad.value        = LOCdispRenderEffect.framePad      -- : integer
    DYNsightTool.SPDYNfontScale.value       = LOCdispRenderEffect.fontScale     -- : integer
    DYNsightTool.CKDYNdimBGCheck.checked    = LOCdispRenderEffect.dimBG         -- : boolean
    DYNsightTool.CKDYNblendCheck.checked    = LOCdispRenderEffect.alphaBlend    -- : boolean
    DYNsightTool.SPDYNreqdDistance.value    = LOCdispRenderEffect.reqdDistance  -- : integer
    DYNsightTool.DDDYNtypeTextTL.selection  = LOCdispRenderEffect.TypeTextTL    -- : integer
    DYNsightTool.DDDYNtypeTextTC.selection  = LOCdispRenderEffect.TypeTextTC    -- : integer
    DYNsightTool.DDDYNtypeTextTR.selection  = LOCdispRenderEffect.TypeTextTR    -- : integer
    DYNsightTool.DDDYNtypeTextBL.selection  = LOCdispRenderEffect.TypeTextBL    -- : integer
    DYNsightTool.DDDYNtypeTextBC.selection  = LOCdispRenderEffect.TypeTextBC    -- : integer
    DYNsightTool.DDDYNtypeTextBR.selection  = LOCdispRenderEffect.TypeTextBR    -- : integer
    DYNsightTool.EDDYNeditTextTL.text       = LOCdispRenderEffect.EditTextTL    -- : string
    DYNsightTool.EDDYNeditTextTC.text       = LOCdispRenderEffect.EditTextTC    -- : string
    DYNsightTool.EDDYNeditTextTR.text       = LOCdispRenderEffect.EditTextTR    -- : string
    DYNsightTool.EDDYNeditTextBL.text       = LOCdispRenderEffect.EditTextBL    -- : string
    DYNsightTool.EDDYNeditTextBC.text       = LOCdispRenderEffect.EditTextBC    -- : string
    DYNsightTool.EDDYNeditTextBR.text       = LOCdispRenderEffect.EditTextBR    -- : string
    DYNsightTool.LBDYNeditTextTL.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextTL]
    DYNsightTool.LBDYNeditTextTC.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextTC]
    DYNsightTool.LBDYNeditTextTR.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextTR]
    DYNsightTool.LBDYNeditTextBL.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextBL]
    DYNsightTool.LBDYNeditTextBC.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextBC]
    DYNsightTool.LBDYNeditTextBR.text       = LOCtxtOptions[LOCdispRenderEffect.TypeTextBR]
    DYNsightTool.CKDYNuseImageCheck.checked = LOCdispRenderEffect.useImage      -- : boolean
    DYNsightTool.EDDYNimageName.text        = LOCdispRenderEffect.imageFName    -- : string
    DYNsightTool.SPDYNimageposx.value       = LOCdispRenderEffect.image_x       -- : integer
    DYNsightTool.SPDYNimageposy.value       = LOCdispRenderEffect.image_y       -- : integer
    DYNsightTool.SPDYNopacity.value         = LOCdispRenderEffect.imgOpacity    -- : integer
    DYNsightTool.DDDYNtransfer.selection    = LOCdispRenderEffect.transfer_mode -- : integer

    DYNsightTool.LBDYNtypeTextTL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNtypeTextTC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNtypeTextTR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNtypeTextBL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNtypeTextBC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNtypeTextBR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextTL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextTC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextTR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextBL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextBC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.DDDYNtypeTextBR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextTL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextTC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextTR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextBL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextBC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.EDDYNeditTextBR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextTL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextTC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextTR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextBL.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextBC.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNeditTextBR.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNfontScale.enabled     = IsActive LOCdispRenderEffect
    DYNsightTool.SPDYNfontScale.enabled     = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNreqdDistance.enabled  = IsActive LOCdispRenderEffect
    DYNsightTool.SPDYNreqdDistance.enabled  = IsActive LOCdispRenderEffect
    DYNsightTool.CKDYNdimBGCheck.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.CKDYNblendCheck.enabled    = IsActive LOCdispRenderEffect
    DYNsightTool.LBDYNframePad.enabled      = IsActive LOCdispRenderEffect
    DYNsightTool.SPDYNframePad.enabled      = IsActive LOCdispRenderEffect
    DYNsightTool.CKDYNuseImageCheck.enabled = IsActive LOCdispRenderEffect

    DYNsightTool.EDDYNimageName.enabled     = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.BUDYNimageNameBtn.enabled  = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.LBDYNimageposx.enabled     = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.SPDYNimageposx.enabled     = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.LBDYNimageposy.enabled     = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.SPDYNimageposy.enabled     = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.LBDYNopacity.enabled       = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.SPDYNopacity.enabled       = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage
    DYNsightTool.DDDYNtransfer.enabled      = IsActive LOCdispRenderEffect and LOCdispRenderEffect.useImage

    DYNFUNgetObjectsWithSpecifiedObjectID DYNsightTool.dnLv DYNsightTool.SPDYNnodeID.value
  )

  on DYNsightTool close do
  (
    if LOCdispRenderEffect != undefined and LOCcalcRenderEffect != undefined then
    (
      if not (isActive LOCdispRenderEffect) and not (isActive LOCcalcRenderEffect) then
      (
        if (querybox (DYNuiResourcesQueries[42]) title:DYNuiResourcesTitlebars[3]) then
        (
          if numEffects > 0 then
          (
            for i = numEffects to 1 by -1 do
            (
              if classof (getEffect i) == Civil_View_Sight_Checker__Calc then deleteEffect i
              if classof (getEffect i) == dSightRender then deleteEffect i
            )
          )
        )
      )
    )
  )

  on CKDYNuseCalc changed arg do
  (
    setActive LOCcalcRenderEffect arg

    LBDYNblend.enabled         = arg
    SPDYNblend.enabled         = arg
    LBDYNnodeID.enabled        = arg
    SPDYNnodeID.enabled        = arg
    PKDYNobject.enabled        = arg
    BUDYNobjectR.enabled       = arg
    CPDYNmarker.enabled        = arg
    CKDYNshowProgress.enabled  = arg
    CKDYNdrawMarker.enabled    = arg
    CKDYNdrawHairs.enabled     = arg
    CKDYNblend.enabled         = arg
    CKDYNoutputName.enabled    = arg
    BUDYNoutputNameBtn.enabled = arg

    DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  )


  on SPDYNblend        changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on CPDYNmarker       changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on CKDYNshowProgress changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on CKDYNdrawMarker   changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on CKDYNdrawHairs    changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on CKDYNblend        changed arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect

  on EDDYNoutputName   entered arg do DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  on EDDYNoutputName changed arg do
  (
    if CKDYNoutputName.checked then LOCcalcRenderEffect.output = arg
  )

  on CKDYNoutputName   changed arg do
  (
    DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
  )

  on SPDYNnodeID       changed arg do
  (
    DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
    DYNFUNgetObjectsWithSpecifiedObjectID DYNsightTool.dnLv arg
  )

  on PKDYNobject       picked  arg do
  (
    arg.gBufferChannel = SPDYNnodeID.value
    DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
    DYNFUNgetObjectsWithSpecifiedObjectID DYNsightTool.dnLv SPDYNnodeID.value
  )

  on BUDYNobjectR pressed do
  (
    if dnLv.selectedItems.count == 1 then
    (
      local LOCnode = maxOps.getNodeByHandle (dnLv.selectedItems.item[0].tag as integer)
      if isValidNode LOCnode then
      (
        LOCnode.gBufferChannel = 0
        DYNFUNgetObjectsWithSpecifiedObjectID DYNsightTool.dnLv SPDYNnodeID.value
      )
    )
  )

  on BUDYNoutputNameBtn pressed do
  (
    local LOCfile = getSaveFileName caption:DYNuiResourcesTitlebars[10] filename:EDDYNoutputName.text types:DYNuiResourcesFileTypes[8]
    if LOCfile != undefined then
    (
      EDDYNoutputName.text = LOCfile
      DYNFUNsetCalcRenderEffectParams LOCcalcRenderEffect
    )
  )

  on CKDYNuseText changed arg do
  (
    setActive LOCdispRenderEffect arg

    LBDYNtypeTextTL.enabled    = arg
    LBDYNtypeTextTC.enabled    = arg
    LBDYNtypeTextTR.enabled    = arg
    LBDYNtypeTextBL.enabled    = arg
    LBDYNtypeTextBC.enabled    = arg
    LBDYNtypeTextBR.enabled    = arg
    DDDYNtypeTextTL.enabled    = arg
    DDDYNtypeTextTC.enabled    = arg
    DDDYNtypeTextTR.enabled    = arg
    DDDYNtypeTextBL.enabled    = arg
    DDDYNtypeTextBC.enabled    = arg
    DDDYNtypeTextBR.enabled    = arg
    EDDYNeditTextTL.enabled    = arg
    EDDYNeditTextTC.enabled    = arg
    EDDYNeditTextTR.enabled    = arg
    EDDYNeditTextBL.enabled    = arg
    EDDYNeditTextBC.enabled    = arg
    EDDYNeditTextBR.enabled    = arg
    LBDYNeditTextTL.enabled    = arg
    LBDYNeditTextTC.enabled    = arg
    LBDYNeditTextTR.enabled    = arg
    LBDYNeditTextBL.enabled    = arg
    LBDYNeditTextBC.enabled    = arg
    LBDYNeditTextBR.enabled    = arg
    LBDYNfontScale.enabled     = arg
    SPDYNfontScale.enabled     = arg
    LBDYNreqdDistance.enabled  = arg
    SPDYNreqdDistance.enabled  = arg
    CKDYNdimBGCheck.enabled    = arg
    CKDYNblendCheck.enabled    = arg
    LBDYNframePad.enabled      = arg
    SPDYNframePad.enabled      = arg
    CKDYNuseImageCheck.enabled = arg

    EDDYNimageName.enabled     = arg and LOCdispRenderEffect.useImage
    BUDYNimageNameBtn.enabled  = arg and LOCdispRenderEffect.useImage
    LBDYNimageposx.enabled     = arg and LOCdispRenderEffect.useImage
    SPDYNimageposx.enabled     = arg and LOCdispRenderEffect.useImage
    LBDYNimageposy.enabled     = arg and LOCdispRenderEffect.useImage
    SPDYNimageposy.enabled     = arg and LOCdispRenderEffect.useImage
    LBDYNopacity.enabled       = arg and LOCdispRenderEffect.useImage
    SPDYNopacity.enabled       = arg and LOCdispRenderEffect.useImage
    DDDYNtransfer.enabled      = arg and LOCdispRenderEffect.useImage

    DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  )

  on CKDYNuseImageCheck changed arg do
  (
    EDDYNimageName.enabled     = arg
    BUDYNimageNameBtn.enabled  = arg
    LBDYNimageposx.enabled     = arg
    SPDYNimageposx.enabled     = arg
    LBDYNimageposy.enabled     = arg
    SPDYNimageposy.enabled     = arg
    LBDYNopacity.enabled       = arg
    SPDYNopacity.enabled       = arg
    DDDYNtransfer.enabled      = arg
    DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  )

  on DDDYNtypeTextTL   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtypeTextTC   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtypeTextTR   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtypeTextBL   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtypeTextBC   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtypeTextBR   selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextTL   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextTC   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextTR   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextBL   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextBC   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNeditTextBR   entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNfontScale    changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNreqdDistance changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on CKDYNdimBGCheck   changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on CKDYNblendCheck   changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNframePad     changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on EDDYNimageName    entered  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNimageposx    changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNopacity      changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on SPDYNimageposy    changed  arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on DDDYNtransfer     selected arg do DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
  on BUDYNimageNameBtn pressed      do
  (
    local LOCimage = getBitmapOpenFileName caption:(DYNuiResourcesTitlebars[34]) filename:EDDYNimageName.text
    if LOCimage != undefined then
    (
      EDDYNimageName.text = LOCimage
      DYNFUNsetDispRenderEffectParams LOCdispRenderEffect
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAJ4Vxgkt5oQS0k4Q1eGbdYAUVTG9pZPdCP
-- csX+MQ1gDyeyeIUigvOBIqc/qon7fUSVsAA9T+a8+NgdGIUDLsntEfArF4dmVD2e
-- FfImiebcAzrpVal4ucAkaJpc/w4UUCu41dEHeaLuBL+R9O4EtIwI7Cfvc0mKfy7+
-- TVXfjth5Pun6zzO2/n3Qjpt/2SmP+A9WrZdma63AP7dufjPaGUNWd0LpMHhoCrTn
-- 4GPrzihnqxBwUffTF25gpX8Q4NdJ7Z0uH1xC3Vskcf20Dkb9SnnGOATnouZEljZH
-- GmYpby2lOE54+KrnwIL6tfgOY/ErEUEcQBKRG+KYDaoBxvADSixf
-- -----END-SIGNATURE-----